/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.block;

import me.ultrusmods.missingwilds.tags.MissingWildsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FallenLogBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;
    public static final EnumProperty<Cover> COVER = EnumProperty.m_61587_((String)"cover", Cover.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape INSIDE_Z = FallenLogBlock.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SHAPE_Z = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)INSIDE_Z, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape INSIDE_X = FallenLogBlock.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    private static final VoxelShape SHAPE_X = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)INSIDE_X, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape INSIDE_Y = FallenLogBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape SHAPE_Y = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)INSIDE_Y, (BooleanOp)BooleanOp.f_82685_);

    public FallenLogBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_(COVER, (Comparable)((Object)Cover.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return direction == Direction.UP ? (BlockState)state.m_61124_(COVER, (Comparable)((Object)FallenLogBlock.getCover(neighborState))) : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_(AXIS);
        switch (axis) {
            case X: {
                return SHAPE_X;
            }
            case Y: {
                return SHAPE_Y;
            }
            case Z: {
                return SHAPE_Z;
            }
        }
        return SHAPE_Y;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return RotatedPillarBlock.m_154376_((BlockState)state, (Rotation)rotation);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, COVER, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockstate = ctx.m_43725_().m_8055_(ctx.m_8083_().m_7494_());
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)ctx.m_43719_().m_122434_())).m_61124_(COVER, (Comparable)((Object)FallenLogBlock.getCover(blockstate)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    private static Cover getCover(BlockState state) {
        if (state.m_204336_(MissingWildsTags.MOSS)) {
            return Cover.MOSSY;
        }
        if (state.m_204336_(MissingWildsTags.SNOW)) {
            return Cover.SNOWY;
        }
        return Cover.NONE;
    }

    public static enum Cover implements StringRepresentable
    {
        NONE("none"),
        MOSSY("moss"),
        SNOWY("snow");

        final String name;

        private Cover(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

